﻿using iTextSharp.text;
using iTextSharp.text.pdf;
using iTextSharp.tool.xml;
using iTextSharp.tool.xml.html.table;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
/// Summary description for TableDataProcessor
/// </summary>
public class TableDataProcessor : TableData
{
    /*
     * a **very** simple implementation of the CSS writing-mode property:
     * https://developer.mozilla.org/en-US/docs/Web/CSS/writing-mode
     */
    bool HasWritingMode(IDictionary<string, string> attributeMap)
    {
        bool hasStyle = attributeMap.ContainsKey("style");
        return hasStyle
                && attributeMap["style"].Split(new char[] { ';' })
                .Where(x => x.StartsWith("writing-mode:"))
                .Count() > 0
            ? true : false;
    }
    bool HasBorderStyle(IDictionary<string, string> attributeMap, string borderStyle)
    {
        var hasStyle = attributeMap.ContainsKey("colp");

        if (!hasStyle)
        {
            return false;
        }

        //var size = attributeMap["colp"];
        //if (size != null)
        //{
        //    if (Convert.ToInt32(size) > 0)
        //    {
        //        return size;
        //    }
        //    else
        //    {
        //        return false;
        //    }
        //}
        //var borderLeft = attributeMap.Contains.TextContent;

        //if (borderLeft != null)
        //{
        //    return borderLeft.Any(o => o.Trim().ToLower() == borderStyle);
        //}

        return true;
    }

    public override IList<IElement> End(IWorkerContext ctx, Tag tag, IList<IElement> currentContent)
    {
        var cells = base.End(ctx, tag, currentContent);
        var pdfPCell = (PdfPCell)cells[0];
        var attributeMap = tag.Attributes;
        if (HasWritingMode(attributeMap))
        {
            
            // **always** 'sideways-lr'
            pdfPCell.Rotation = 90; 

        }
        if (HasBorderStyle(attributeMap, "left"))
        {
            
            pdfPCell.Colspan = Convert.ToInt32(attributeMap["colp"]);
           
            //pdfPCell.CellEvent = new DottedCell(Rectangle.LEFT_BORDER);
        }

        pdfPCell.Padding = 5;
       
        //new System.Collections.Generic.Mscorlib_DictionaryDebugView<string, string>(attributeMap).Items[0].Key 
        return cells;
    }
}